/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.TargetHelper;
import dangerzone.items.Item;
import dangerzone.items.ItemAxe;
import dangerzone.items.ItemPickAxe;
import dangerzone.items.ItemShovel;
import dangerzone.items.ItemSword;
import dangerzone.items.Items;
import org.newdawn.slick.opengl.Texture;

public class Fairy
extends EntityLiving {
    float myspeed = 0.0f;
    int searchcounter = 0;
    Entity targetentity = null;
    Entity hurtMe = null;
    public Texture texture2 = null;
    public Texture texture3 = null;
    public Texture texture4 = null;
    public Texture texture5 = null;
    public Texture texture6 = null;
    public Texture texture7 = null;
    public Texture texture8 = null;
    public Texture texture9 = null;
    float attackRange = 1.5f;

    public Fairy(World w) {
        super(w);
        this.maxrenderdist = 100;
        this.height = 0.55f;
        this.width = 0.55f;
        this.uniquename = "OreSpawn:Fairy";
        this.setMaxHealth(20.0f);
        this.setHealth(20.0f);
        this.setDefense(1.0f);
        this.setAttackDamage(5.0f);
        if (w != null) {
            this.myspeed = 0.15f + this.world.rand.nextFloat() * 0.15f;
        }
        this.takesFallDamage = false;
        if (w != null) {
            this.setBID(w.rand.nextInt(9) + 1);
        } else {
            this.setBID(DangerZone.rand.nextInt(9) + 1);
        }
        this.setExperience(15);
        this.daytimespawn = true;
        this.nighttimespawn = true;
        this.daytimedespawn = true;
        this.nighttimedespawn = true;
        this.canFly = true;
        this.setFlying(true);
    }

    public void doAttackFrom(Entity e, int dt, float pain) {
        if (e != this && !DangerZone.playnicely) {
            this.hurtMe = e;
        }
        super.doAttackFrom(e, dt, pain);
    }

    public void doEntityAction(float deltaT) {
        ++this.searchcounter;
        if (this.searchcounter >= 10) {
            this.searchcounter = this.world.rand.nextInt(4);
            if (this.hurtMe != null && this.hurtMe.deadflag) {
                this.hurtMe = null;
            }
            if (this.world.rand.nextInt(20) == 1) {
                this.hurtMe = null;
            }
            this.targetentity = this.hurtMe;
            if (this.targetentity == null) {
                this.targetentity = this.findSomethingToAttack();
            }
            if (this.targetentity != null) {
                this.target = new TargetHelper(this.targetentity, this.targetentity.posx, this.targetentity.posy + (double)(this.targetentity.getHeight() * 3.0f / 4.0f), this.targetentity.posz);
                this.setAttacking(true);
            } else {
                this.setAttacking(false);
            }
        }
        if (this.targetentity != null && this.world.rand.nextInt(10) == 1 && this.getDistanceFromEntity(this.targetentity) < (double)(this.attackRange + this.targetentity.getWidth() / 2.0f + this.getWidth() / 2.0f)) {
            InventoryContainer ic;
            float dmg = this.getAttackDamage();
            int dt = 4;
            if (this.has_inventory && (ic = this.getHotbar(this.gethotbarindex())) != null) {
                if (ic.bid != 0) {
                    dt = 3;
                } else if (ic.iid > 0 && ic.iid < 2048) {
                    dmg = Items.getAttackStrength((int)ic.iid);
                    dt = 0;
                    Item it = ic.getItem();
                    if (it != null) {
                        if (it instanceof ItemSword) {
                            dt = 1;
                        }
                        if (it instanceof ItemPickAxe) {
                            dt = 2;
                        }
                        if (it instanceof ItemAxe) {
                            dt = 2;
                        }
                        if (it instanceof ItemShovel) {
                            dt = 2;
                        }
                    }
                }
            }
            this.targetentity.doAttackFrom((Entity)this, dt, dmg);
        }
        this.doLookAction();
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Player) {
            return false;
        }
        return e.temperament == 1 && this.CanProbablySeeEntity(e);
    }

    public void update(float deltaT) {
        if (this.world.isServer) {
            int bid;
            int keep_trying = 25;
            float speedadjust = 1.0f;
            if (this.getCanDespawn() && this.world.rand.nextInt(5000) == 1) {
                this.deadflag = true;
            }
            if (this.world.rand.nextInt(3) == 1) {
                Utils.spawnParticlesFromServer((World)this.world, (String)"DangerZone:ParticleSparkle", (int)1, (int)this.dimension, (double)this.posx, (double)(this.posy - 0.25), (double)this.posz);
            }
            if (this.target == null) {
                this.target = new TargetHelper(this.posx, this.posy, this.posz);
            }
            if ((bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz)) != 0 || this.world.rand.nextInt(50) == 1 || this.target.getDistanceToTarget(this.posx, this.posy, this.posz) < 2.0) {
                Entity e;
                double px = this.posx;
                double py = this.posy;
                double pz = this.posz;
                int dxz = 25;
                double dist = 0.0;
                if (this.getOwnerName() != null && (e = DangerZone.server.entityManager.findPlayerByName(this.getOwnerName())) != null) {
                    px = e.posx;
                    py = e.posy + (double)(e.getHeight() / 2.0f);
                    pz = e.posz;
                    dxz = 16;
                    dist = this.getDistanceFromEntity(e);
                    if (dist > (double)this.maxdisttoowner) {
                        speedadjust = 1.75f;
                    }
                    if (dist > (double)(this.maxdisttoowner * 1.5f)) {
                        speedadjust = 2.75f;
                    }
                }
                bid = 1;
                while (bid != 0 && keep_trying != 0) {
                    this.target.setTarget(px + (double)(this.world.rand.nextInt(dxz) - this.world.rand.nextInt(dxz)), py + (double)(this.world.rand.nextInt(7) - 2), pz + (double)(this.world.rand.nextInt(dxz) - this.world.rand.nextInt(dxz)));
                    bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz);
                    --keep_trying;
                }
                this.myspeed = 0.15f + this.world.rand.nextFloat() * 0.15f;
            }
            if ((bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz)) != 0) {
                this.target.setTarget(this.posx + (double)(this.world.rand.nextInt(5) - this.world.rand.nextInt(5)), this.posy + (double)(this.world.rand.nextInt(5) + 3), this.posz + (double)(this.world.rand.nextInt(5) - this.world.rand.nextInt(5)));
            }
            double dy = this.target.targety - this.posy;
            this.motiony += 0.12f * deltaT;
            if ((dy /= 20.0) > (double)0.2f) {
                dy = 0.2f;
            }
            if (dy < (double)-0.2f) {
                dy = -0.2f;
            }
            this.motiony = (float)((double)this.motiony + dy);
            if (this.motiony > 1.0f) {
                this.motiony = 1.0f;
            }
            if (this.motiony < -1.0f) {
                this.motiony = -1.0f;
            }
            float cdir = (float)Math.toRadians(this.rotation_yaw);
            float tdir = (float)Math.atan2(this.target.targetx - this.posx, this.target.targetz - this.posz);
            float ddiff = tdir - cdir;
            while ((double)ddiff > Math.PI) {
                ddiff = (float)((double)ddiff - Math.PI * 2);
            }
            while ((double)ddiff < -Math.PI) {
                ddiff = (float)((double)ddiff + Math.PI * 2);
            }
            this.rotation_yaw_motion = (float)((double)this.rotation_yaw_motion + (double)(ddiff * 180.0f) / Math.PI / 10.0);
            float effectspeed = this.getTotalEffect(1);
            if (effectspeed > 1.0f) {
                speedadjust *= effectspeed;
            }
            if ((effectspeed = this.getTotalEffect(2)) > 1.0f) {
                speedadjust /= effectspeed;
            }
            this.motionx = (float)((double)this.motionx + (double)(this.myspeed * speedadjust) * Math.sin(tdir) * (double)deltaT);
            this.motionz = (float)((double)this.motionz + (double)(this.myspeed * speedadjust) * Math.cos(tdir) * (double)deltaT);
        }
        super.update(deltaT);
    }

    public void doDeathDrops() {
        int howmany = 1 + this.world.rand.nextInt(3);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)OreSpawnMain.crystaltorch.blockID, (int)0, (float)2.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophyfairy.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/fairytexture.png");
            this.texture2 = TextureMapper.getTexture((String)"orespawnres/skins/fairytexture2.png");
            this.texture3 = TextureMapper.getTexture((String)"orespawnres/skins/fairytexture3.png");
            this.texture4 = TextureMapper.getTexture((String)"orespawnres/skins/fairytexture4.png");
            this.texture5 = TextureMapper.getTexture((String)"orespawnres/skins/fairytexture5.png");
            this.texture6 = TextureMapper.getTexture((String)"orespawnres/skins/fairytexture6.png");
            this.texture7 = TextureMapper.getTexture((String)"orespawnres/skins/fairytexture7.png");
            this.texture8 = TextureMapper.getTexture((String)"orespawnres/skins/fairytexture8.png");
            this.texture9 = TextureMapper.getTexture((String)"orespawnres/skins/fairytexture9.png");
        }
        if (this.getBID() == 1) {
            return this.texture2;
        }
        if (this.getBID() == 2) {
            return this.texture3;
        }
        if (this.getBID() == 3) {
            return this.texture4;
        }
        if (this.getBID() == 4) {
            return this.texture5;
        }
        if (this.getBID() == 5) {
            return this.texture6;
        }
        if (this.getBID() == 6) {
            return this.texture7;
        }
        if (this.getBID() == 7) {
            return this.texture8;
        }
        if (this.getBID() == 8) {
            return this.texture9;
        }
        return this.texture;
    }

    public String getHurtSound() {
        return "OreSpawn:duck_hurt";
    }

    public String getDeathSound() {
        return "DangerZone:little_splat";
    }

    public String getLivingSound() {
        return null;
    }
}

